# bot.py
import os
from urllib.parse import urlparse
from playwright.sync_api import sync_playwright

def bot_fetch(url: str, villain: str = "Bane"):
    # Get that fuckin flag
    if villain == "Bane":
        flag = os.environ.get("FLAG1", "FLAG{lv1_placeholder}")
    elif villain == "Riddler":
        flag = os.environ.get("FLAG2", "FLAG{lv2_placeholder}")
    elif villain == "Mr. Freeze":
        flag = os.environ.get("FLAG4", "FLAG{lv4_placeholder}")
    elif villain == "Joker":
        raise Exception("Joker doesn't respond to anything!")
    else:
        raise Exception("Villain doesn't exist! (YOU SHOULD NEVER GET THIS ERROR WHY ARE YOU HERE)")

    # Get domain
    parsed_url = urlparse(url)
    cookie_domain = parsed_url.hostname

    # Actually run the Playwright bot
    with sync_playwright() as p:
        browser = p.chromium.launch(headless=True, args=["--no-sandbox"])
        context = browser.new_context()
        
        # Set flag cookie
        context.add_cookies([{
            'name': 'FLAG',
            'value': flag,
            'domain': cookie_domain,
            'path': '/',
            'httpOnly': False,
            'secure': False,
            'sameSite': 'Lax'
        }])

        print(context.cookies)

        page = context.new_page()

        try:
            page.goto(url, wait_until="networkidle", timeout=10000)
            print(f"[BOT] Bot visited {url} successfully.")
        except Exception as e:
            print(f"[BOT] Error visiting {url}: {e}")
        finally:
            context.close()
            browser.close()

def bot_report(url: str):
    """Bot investigates a reported URL as Joker (for CSRF challenge)"""
    print(f"[BOT] bot_report: Joker investigating reported URL: {url}")
    
    # Get the base URL from environment
    base_url = "http://ctf.batmans.kitchen"
    parsed_base = urlparse(base_url)
    parsed_submitted = urlparse(url)
    
    # Check if user is trying to report the base URL itself
    if parsed_submitted.netloc == parsed_base.netloc:
        print(f"[BOT] Nice try! User attempted to report same domain: {url}")
        raise Exception("Nice try! The Joker won't investigate his own domain.")
    
    flag = os.environ.get("FLAG3", "FLAG{lv3_placeholder}")
    cookie_domain = parsed_base.hostname
    
    with sync_playwright() as p:
        browser = p.chromium.launch(headless=True, args=["--no-sandbox"])
        context = browser.new_context()
        
        # Set the flag as a cookie for the main domain
        context.add_cookies([{
            'name': 'FLAG',
            'value': flag,
            'domain': cookie_domain,
            'path': '/',
            'httpOnly': False,
            'secure': False,
            'sameSite': 'Lax'
        }])
        
        page = context.new_page()
        
        try:
            # First visit the main site to establish session
            print(f"[BOT] Joker visiting main site: {base_url}")
            page.goto(base_url, wait_until="networkidle", timeout=10000)
            page.wait_for_timeout(1000)
            
            # Now visit the attacker's reported URL (which will do CSRF)
            print(f"[BOT] Joker now visiting reported URL: {url}")
            page.goto(url, wait_until="networkidle", timeout=10000)
            
            # Give CSRF payload time to execute
            page.wait_for_timeout(1000)
            
            print(f"[BOT] Joker successfully investigated: {url}")
            
        except Exception as e:
            print(f"[BOT] Error in Joker investigation: {e}")
        finally:
            context.close()
            browser.close()