# models.py
from sqlalchemy import create_engine, Column, Integer, String, Text, ForeignKey
from sqlalchemy.orm import declarative_base, sessionmaker, relationship
import secrets
import os

Base = declarative_base()
DB_URL = os.environ.get("DATABASE_URL", "sqlite:///data.db")
engine = create_engine(DB_URL, connect_args={"check_same_thread": False})
SessionLocal = sessionmaker(bind=engine)

class User(Base):
    __tablename__ = "users"
    id = Column(Integer, primary_key=True)
    username = Column(String(80), unique=True, nullable=False)
    password = Column(String(200), nullable=False)
    is_bot = Column(Integer, default=0)  # 1 = bot (e.g., Joker), 0 = human

class Post(Base):
    __tablename__ = "posts"
    id = Column(Integer, primary_key=True)
    author_id = Column(Integer, ForeignKey("users.id"))
    recipient = Column(String(80))
    content = Column(Text)
    author = relationship("User", backref="posts")

def init_db():
    """Initialize the Gotham database — create tables and seed initial villains."""
    Base.metadata.create_all(bind=engine)
    session = SessionLocal()

    # Create initial Gotham villains if not present
    pw = secrets.token_urlsafe(69)
    initial_users = [
        {"username": "Bane", "password": pw, "is_bot": 0},
        {"username": "The Riddler", "password": pw, "is_bot": 0},
        {"username": "Joker", "password": pw, "is_bot": 1},
    ]

    for u in initial_users:
        existing = session.query(User).filter_by(username=u["username"]).first()
        if not existing:
            session.add(User(**u))

    session.commit()
    return session
